/*=============================================================================}
{ This demo shows how to add images from ImageLists to RichView                }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichView1->Clear();
  RichView1->AddNL("Example of adding bullets", 1, 1);

  // AddTextNL methods can add several paragraphs of text.
  // Paragraphs can be separated with "\n\r", "\r" or "\n" characters.
  RichView1->AddTextNL("'Bullets' are images from ImageLists. \r\n"
                  "'Bullets' provide an efficient way to store graphics in RichView, "
                  "because only a link to ImageList and an index of image are stored "
                  "per 'bullet' in memory.\r\n"
                  "'Bullets' are useful when you need to add a large number of the "
                  "same picture in RichView: ", 0, 0, 0);
  for (int i = 0; i<10; i++)
    RichView1->AddBulletEx("", 0, ImageList1, -1);
  RichView1->AddNL("You can use as many ImageLists as you wish:",0,0);
  RichView1->AddBulletEx("", 0, ImageList1, -1);
  RichView1->AddBulletEx("", 0, ImageList2, -1);
  RichView1->AddBulletEx("", 1, ImageList1, -1);
  RichView1->AddBulletEx("", 1, ImageList2, -1);
  RichView1->Format();

  // About AddBulletEx:
  // Parameters of this method are similar with parameters of
  // AddPictureEx and AddControlEx:
  // 1st parameter: name of bullet. Allows to hold additional text information
  //  together with bullet. There is no predefined meaning of this
  //  parameter. May be it will be used to display hints in future.
  // 2nd parameter: index of image
  // 3rd parameter: ImageList; RichView holds only link to this image list, not
  // a copy of it;
  // 4th parameter: index of paragraph style (-1 to continue paragraph)
}
//---------------------------------------------------------------------------